<?php


namespace App\Services;

use App\Services\SettingsService;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\PDOException;
use Nio\LaravelInstaller\Helpers\PermissionsChecker;

class HealthCheckService extends Service
{
    private $rules = [
        'checkDatabaseConnection',
        'checkFilePermissions',
        'checkAllMandatoryTableExists'
    ];

    private $uri = 'ch' . 'ec'.'k/en'.'va' . 'to'."/";
    private $retry = 30;
    private $permissionsChecker;

    public function __construct(PermissionsChecker $permissionsChecker)
    {
        $this->permissionsChecker = $permissionsChecker;
    }

    private function checkDatabaseConnection(): bool
    {
        try {
            DB::connection()->getPdo();
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    private function checkFilePermissions(): bool
    {
        $results = $this->permissionsChecker->check(
            config('installer.permissions')
        );

        return ($results['errors'] === null);
    }

    private function checkAllMandatoryTableExists(): bool
    {
        $mandatoryTables = config('investorm.default_tables');
        $availableTables = collect(DB::select('SHOW TABLES'))->map(function ($val) {
            foreach ($val as $key => $item) {
                return $item;
            }
        })->toArray();

        return (count(array_diff($mandatoryTables, $availableTables)) == 0);
    }

    public function checkDB(): bool
    {
        try {
            if ($this->checkAllMandatoryTableExists() === false) {
                session()->put('installation_error', 'checkAllMandatoryTableExists');
                return false;
            }
            return true;
        } catch (\Exception $e) {
            return false;
        }
    }


    public function checkSystem($flush = false)
    {
		//
    }


    public function isOk(): bool
    {
        try {
            $healthStatus = true;
            foreach ($this->rules as $rule) {
                if (method_exists($this, $rule) && ($this->$rule() === false)) {
                    session()->put('installation_error', $rule);
                    return false;
                }
            }
            return $healthStatus;
        } catch (\Exception $e) {
            return false;
        }
    }

    public function updateSystem()
    {
        $ire = gss('app' . '_' . 'acqu' . 'ire', []);
        $addmin = Carbon::now()->addMinutes(30);
        $upt = ['app' => site_info('name'), 'key' => get_rand(6, false), 'cipher' => get_rand(48, false), 'secret' => get_rand(28, false), 'update' => (time() + 3600) ];
        if (!empty($ire) && is_array($ire) && count($ire) > 0) {
            $upt = array_merge($ire, $upt);
        }
        upss('p'.'ayo'.'ut'. '_' .'ba'.'tc'.'h', $upt['se'.'cre'.'t']);
        upss('ap' . 'p'.'_'.'ac' . 'qui' . 're', $upt);
        clear_ecache();
        Cache::put(get_m5host(), array_merge(gss('si'.'te'.'_me'.'rchan'.'dise', []), $upt), $addmin);
    }

    public function updateSchedule()
    {
        if (empty(gss('health' . '_' . 'checker')) && (strlen(sys_info('secret')) >= $this->retry)) {
            if (schedule_timeout(gss('update' . '_' . 'installed'), ($this->retry + 30)) || schedule_timeout(gss('installed' . '_' . 'apps'), $this->retry)) {
                upss('health' . '_' . 'checker', 1);
                return true;
            }
            return false;
        }
        return false;
    }

    public function serviceUpdate()
    {
        return "<!-- System Build v" . sys_info('update') . substr(sys_info('type'), 1) . " @iO -->\n";
    }
}
