<?php

namespace App\Http\Requests\User\Transaction;

use Illuminate\Foundation\Http\FormRequest;

class DepositPreviewRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "deposit_amount" => ['required', 'numeric'],
            "deposit_currency" => ['required', 'string'],
            "deposit_amount_by" => ['required', 'numeric', 'in:1,2'],
            "credit_amount" => ['required', 'numeric'],
            "credit_currency" => ['required', 'string'],
            "deposit_payment_method" => ['required', 'string'],
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'deposit_amount.required' => __('Please enter your amount to deposit.'),
            'deposit_amount.numeric' => __('Please enter a valid amount for deposit.'),
            'deposit_currency.required' => __('Choose your deposited currency.'),
            'credit_amount.*' => __('Please enter a valid amount for deposit.'),
        ];
    }
}
