<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateEmailRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $user = $this->user();

        if (blank($user)) {
            $user = session()->get('verification_required');
        }

        return [
            'email' => 'required|email|regex:/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,9}$/ix|required|max:190|not_in:' . $user->email . '|unique:users,email,' . $user->id
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'email.required' => __("Please enter a valid email address."),
            'email.email' => __("Please enter a valid email address."),
            'email.regex' => __("Please enter a valid email address."),
            'email.not_in' => __("The new email address cannot be the same as current address."),
            'email.unique' => __("An account with the given email already exists."),
        ];
    }
}
