<?php

namespace App\Http\Requests\Invest\User;

use Illuminate\Foundation\Http\FormRequest;

class PreviewInvestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'scheme' => 'required',
            'amount' => 'required|numeric|not_in:0',
            'source' => 'required',  
        ];
    }

/**
 * Get the error messages for the defined validation rules.
 *
 * @return array
 */
public function messages()
    {
        return [
            'scheme.required' => __("Please choose an investment plan."),
            'amount.*' => __("Please enter an amount for investment."),
            'source.required' => __("Please select your payment source."),
        ];
    }
}
