<?php


namespace App\Http\Controllers;

use App\Enums\PageStatus;
use App\Exceptions\Page\GssEmptyException;
use App\Exceptions\Page\PidPageException;
use App\Services\PageService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class PageController extends Controller
{
    private $pageService;

    public function __construct(PageService $pageService)
    {
        $this->pageService = $pageService;
    }
    public function __invoke(Request $request, $slug)
    {
        try {
            $data = $this->pageService->pages($request, $slug);
            $logged = data_get($data, 'logged');
            $access = data_get($data, 'access');
            $status = data_get($data, 'status');
            $admins = data_get($data, 'admins');

            if ($access == 'login' && $status == PageStatus::ACTIVE && !$logged) {
                return redirect()->route('auth.login.form');
            }
            if ($admins) {
                return view('frontend.pages')->with($data);
            }
            if ($status == PageStatus::ACTIVE) {
                return ($logged) ? view('user.pages')->with($data) : view('frontend.pages')->with($data);
            }
            App::abort(404);
        } catch (GssEmptyException $e) {
            return redirect()->route('ap'.'p.se'.'rv'.'ice');
        } catch (PidPageException $e) {
            $page = $e->getData();
            return redirect()->route('show.page', ['slug' => data_get($page, 'mainPage.slug')]);
        }
    }
}
