<?php

namespace App\Helpers;

use SimpleSoftwareIO\QrCode\Facades\QrCode;

class NioQR
{
    /**
     * @param string $qrcode
     * @param int $size
     *
     * @return object|boolean
     */
    public static function generate($qrcode = null, $size = null)
    {
        $def  = 125;
        $size = (!empty($size)) ? (int) $size : $def;

        if ($qrcode) {
            $qrsize = ($size) ? $size : $def;
            return QrCode::size($qrsize)->generate($qrcode);
        }

        return '';
    }

    public static function getContextQR($config, $transaction, $currencyName)
    {
        $qropt = data_get($config, 'meta.qr');
        $contextQR = str_replace(" ", "-", strtolower($currencyName)) . ":" . $transaction->pay_to . "?amount=" . amount($transaction->tnx_total, $transaction->tnx_currency, ['dp' => 'calc', 'zero' => true]);

        if (in_array($qropt, ['only', 'hide'])) {
            $contextQR = ($qropt == 'only') ? $transaction->pay_to : '';
        }

        return $contextQR;
    }
}
